<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->float('user_id');
			$table->integer('vat');
			$table->string('total', 32);
			$table->integer('quantity');
			$table->string('charge');
			$table->datetime('to_date');
			$table->datetime('from_date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}