<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('boards', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('processes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->foreign('board_id')->references('id')->on('boards')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('process_id')->references('id')->on('processes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('boards', function(Blueprint $table) {
			$table->dropForeign('boards_project_id_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_parent_id_foreign');
		});
		Schema::table('processes', function(Blueprint $table) {
			$table->dropForeign('processes_board_id_foreign');
		});
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_process_id_foreign');
		});
	}
}