<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLimFieldsTable extends Migration {

	public function up()
	{
		Schema::create('lim_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('table_id')->unsigned();
			$table->string('table_type', 128);
			$table->enum('type', array('text', 'textarea', 'select', 'multiple_select', 'checkbox', 'checkbox_list', 'radio', 'radio_list', 'file', 'image'));
			$table->integer('rank')->unsigned();
			$table->string('system_name')->unique()->default('32');
			$table->string('icon', 64);
		});
	}

	public function down()
	{
		Schema::drop('lim_fields');
	}
}