<?php

namespace App\Models;

class FieldItems extends Eloquent {

	protected $table = 'lim_field_items';
	public $timestamps = true;
	protected $fillable = array('lim_field_id', 'status', 'rank', 'icon');
	protected $visible = array('lim_field_id', 'status', 'rank', 'icon');

	public function language()
	{
		return $this->hasOne('App\Models\FieldItemLanguage', 'lim_field_item_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function field()
	{
		return $this->belongsTo('App\Models\Fields', 'lim_field_id');
	}

	public function languages()
	{
		return $this->hasMany('App\Models\FieldItemLanguage', 'lim_field_item_id');
	}

}