<?php

namespace App\Models;

class Gallery extends Eloquent {

	protected $table = 'lim_galleries';
	public $timestamps = true;
	protected $fillable = array('lim_gallery_template_id', 'template_setting_json');
	protected $visible = array('lim_gallery_template_id', 'template_setting_json');

	public function language()
	{
		return $this->hasOne('App\Models\GalleryLanguage', 'lim_gallery_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function languages()
	{
		return $this->hasMany('App\Models\GalleryLanguage', 'lim_gallery_id');
	}

	public function template()
	{
		return $this->belongsTo('App\Models\GalleryTemplates', 'lim_gallery_template_id');
	}

	public function images()
	{
		return $this->morphMany('App\Models\Image', 'table');
	}

}