<?php

namespace App\Models;

class SeoTemplate extends Eloquent {

	protected $table = 'lim_seo_templates';
	public $timestamps = true;
	protected $fillable = array('template');
	protected $visible = array('template');

	public function languages()
	{
		return $this->hasMany('App\Models\SeoTemplateTemplateLanguage', 'lim_seo_template_id');
	}

	public function language()
	{
		return $this->hasOne('App\Models\SeoTemplateTemplateLanguage', 'lim_seo_template_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function fields()
	{
		return $this->hasMany('App\Models\SeoField', 'lim_seo_template_id');
	}

}