<?php

namespace App\Models;

class SettingLanguage extends Eloquent {

	protected $table = 'lim_setting_languages';
	public $timestamps = true;
	protected $fillable = array('lim_language_id', 'lim_setting_id', 'label', 'value', 'description');
	protected $visible = array('lim_language_id', 'lim_setting_id', 'label', 'value', 'description');

	public function language()
	{
		return $this->belongsTo('App\Models\Language', 'lim_language_id');
	}

	public function setting()
	{
		return $this->belongsTo('App\Models\Setting', 'lim_setting_id');
	}

}