<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvitesTable extends Migration {

	public function up()
	{
		Schema::create('invites', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('evenement_id')->unsigned()->nullable();
			$table->integer('table_id')->unsigned()->nullable();
			$table->integer('invite_id')->unsigned()->nullable();
			$table->string('slug', 255)->nullable();
			$table->string('qr_code', 255)->nullable();
			$table->string('nom', 255)->nullable();
			$table->string('prenom', 255)->nullable();
			$table->string('sexe', 255)->nullable();
			$table->string('telephone', 255)->nullable();
			$table->string('email', 255)->nullable();
			$table->string('lien', 255)->nullable();
			$table->string('type', 255)->nullable()->default('invite');
			$table->string('statut_invitation', 10)->nullable()->default('0');
			$table->string('statut', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('invites');
	}
}