<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Lesson extends Model 
{

    protected $table = 'lesson';
    public $timestamps = true;

    public function fehmoUsers()
    {
        return $this->belongsToMany('User', 'fahem');
    }

    public function authorType()
    {
        return $this->belongsTo('AuthorType');
    }

    public function status()
    {
        return $this->belongsTo('LessonStatus');
    }

    public function competitionSubmission()
    {
        return $this->hasOne('Submission');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function author()
    {
        return $this->belongsTo('User');
    }

    public function section()
    {
        return $this->belongsTo('Section');
    }

}