<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonTable extends Migration {

	public function up()
	{
		Schema::create('lesson', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->tinyInteger('authortype_id')->index();
			$table->tinyInteger('country_id')->index();
			$table->text('content');
			$table->tinyInteger('lessonstatus_id')->index();
			$table->bigInteger('section_id')->index();
			$table->string('slug', 250)->unique();
			$table->text('videos');
			$table->tinyInteger('videos_count')->unsigned()->default('0');
			$table->string('youtube', 100);
		});
	}

	public function down()
	{
		Schema::drop('lesson');
	}
}