<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Relationship extends Model 
{

    protected $table = 'relationship';
    public $timestamps = true;
    protected $fillable = array('user_one_id', 'user_to_id', 'status', 'action_user_id');
    protected $visible = array('user_one_id', 'user_to_id', 'status', 'action_user_id');

    public function userOne()
    {
        return $this->belongsTo('App\User', 'user_one_id');
    }

    public function userTwo()
    {
        return $this->belongsTo('App\User', 'user_two_id');
    }

    public function actionUser()
    {
        return $this->belongsTo('App\User', 'action_user_id');
    }

}