<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('posted_by')->unsigned();
			$table->longText('contents')->nullable();
			$table->string('image')->nullable();
			$table->bigInteger('watching')->default('0');
			$table->enum('status', array('Active', 'Inactive', 'Deleted'))->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}