<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsTable extends Migration {

	public function up()
	{
		Schema::create('news', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('posted_by')->unsigned();
			$table->longText('contents')->nullable();
			$table->string('image')->nullable();
			$table->bigInteger('share_count')->default('0');
			$table->enum('type', array('Self', 'Shared'))->nullable();
			$table->bigInteger('shared_by')->unsigned();
			$table->enum('status', array('Active', 'Inactive', 'Deleted'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('news');
	}
}