<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemReservationTable extends Migration {

	public function up()
	{
		Schema::create('item_reservation', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('reservation_id')->unsigned();
			$table->bigInteger('item_id')->unsigned();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('item_reservation');
	}
}