<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchsTable extends Migration {

	public function up()
	{
		Schema::create('branchs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('address')->nullable();
			$table->string('lat')->nullable();
			$table->string('long')->nullable();
			$table->integer('work_hours')->nullable();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('branchs');
	}
}