<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFinanceCategoryTable extends Migration {

	public function up()
	{
		Schema::create('finance_category', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('icon')->nullable();
			$table->bigInteger('sub_of')->unsigned()->nullable();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('finance_category');
	}
}