<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Client extends Eloquent {

	protected $table = 'clients';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone1', 'phone2', 'location', 'created_by', 'updated_by');

	public function reservations()
	{
		return $this->hasMany('App\Models\Reservation', 'client_id');
	}

}