<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Permissions extends Eloquent {

	protected $table = 'permissions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'created_by', 'updated_by');

	public function role()
	{
		return $this->belongsTo('App\Models\Role');
	}

}