<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserBrach extends Eloquent {

	protected $table = 'user_branch';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'user_id', 'updated_by', 'created_by');

	public function branchs()
	{
		return $this->hasMany('App\Models\Bransh', 'branch_id');
	}

	public function users()
	{
		return $this->hasMany('App\Models\User', 'user_id');
	}

}