<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FinanceCash extends Eloquent {

	protected $table = 'finance_cash';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('amount', 'date', 'status', 'finance_category_id', 'created_by', 'updated_by');

	public function category()
	{
		return $this->belongsTo('App\Models\CategoryFinance', 'cat_id');
	}

}