<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserBranchTable extends Migration {

	public function up()
	{
		Schema::create('user_branch', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('branch_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->bigInteger('created_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_branch');
	}
}