<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlayerTable extends Migration {

	public function up()
	{
		Schema::create('player', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('score')->nullable();
			$table->string('name', 255);
			$table->smallInteger('placement')->unsigned()->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('player');
	}
}