<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurant';
    public $timestamps = true;

    public function city()
    {
        return $this->hasOne('City');
    }

    public function cuisines()
    {
        return $this->hasMany('Cuisine');
    }

    public function reviewers()
    {
        return $this->belongsToMany('Customer');
    }

    public function promotions()
    {
        return $this->hasMany('Promotion');
    }

}