<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned();
			$table->integer('payment_id')->unsigned();
			$table->integer('state_id')->unsigned();
			$table->string('notes');
			$table->decimal('subtotal');
			$table->decimal('delivery_fee');
			$table->decimal('total');
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}