<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceItemTable extends Migration {

	public function up()
	{
		Schema::create('invoice_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('description')->nullable();
			$table->double('amount')->default('0');
			$table->enum('currency', array('aed', 'mru'));
			$table->integer('quantity')->default('1');
			$table->double('total')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('invoice_item');
	}
}