<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentTable extends Migration {

	public function up()
	{
		Schema::create('shipment', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('container_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->integer('total_items')->unsigned()->nullable();
			$table->double('total_price')->default('0');
			$table->double('total_area')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('shipment');
	}
}