<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 191);
			$table->string('slug', 191);
			$table->longText('content');
			$table->string('thumbnail', 191)->nullable();
			$table->text('description');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id')->unsigned();
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}