<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('key', 100);
			$table->text('value');
			$table->text('detail')->nullable();
			$table->string('type', 191)->nullable();
			$table->integer('order')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}