<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Posts extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'slug', 'content', 'thumbnail', 'description');

	public function user()
	{
		return $this->belongsTo('Users');
	}

	public function category()
	{
		return $this->belongsTo('Categories');
	}

}