<?php

namespace App;

class Users extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('username', 'email');

	public function role()
	{
		return $this->belongsToMany('Roles', 'user_role');
	}

	public function login()
	{
		return $this->hasMany('Login');
	}

	public function usermeta()
	{
		return $this->hasOne('Metas');
	}

	public function messages()
	{
		return $this->hasMany('Messages');
	}

	public function social()
	{
		return $this->hasMany('Socials');
	}

	public function setting()
	{
		return $this->hasOne('User_setting');
	}

	public function post()
	{
		return $this->hasMany('Posts');
	}

	public function order()
	{
		return $this->hasMany('Orders');
	}

}