<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Area extends Eloquent {

	protected $table = 'area';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function admin()
	{
		return $this->belongsTo('App\Models\Admin');
	}

	public function users()
	{
		return $this->hasMany('App\Models\User');
	}

}