<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Specialization extends Eloquent {

	protected $table = 'specializations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function admin()
	{
		return $this->belongsTo('App\Models\Admin');
	}

	public function users()
	{
		return $this->belongsToMany('App\Models\User');
	}

	public function media()
	{
		return $this->hasOne('App\Models\Media');
	}

}