<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestPointsTable extends Migration {

	public function up()
	{
		Schema::create('request_points', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('location_lat');
			$table->float('location_long');
			$table->integer('passenger_id')->unsigned();
			$table->integer('min_fare');
			$table->integer('max_fare');
			$table->integer('driver_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('request_points');
	}
}