<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionFormsTable extends Migration {

	public function up()
	{
		Schema::create('section_forms', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('multi_package_section_id')->unsigned();
			$table->integer('package_id')->unsigned();
			$table->integer('schedule_form_id')->unsigned();
			$table->string('email');
			$table->string('name');
			$table->double('amount')->nullable();
			$table->string('phone');
			$table->string('resume')->nullable();
			$table->double('recording_amount')->nullable();
			$table->string('short_description')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('section_forms');
	}
}