<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantOpeningHoursTable extends Migration {

	public function up()
	{
		Schema::create('restaurant_opening_hours', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned();
			$table->tinyInteger('weekday');
			$table->time('start');
			$table->time('end');
			$table->boolean('active')->default(false);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurant_opening_hours');
	}
}