<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersInternalNotesTable extends Migration {

	public function up()
	{
		Schema::create('users_internal_notes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('created_by_user_id');
			$table->text('note')->nullable();
			$table->boolean('sticky')->default(false);
			$table->string('file', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users_internal_notes');
	}
}