<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lef_source_mapping', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lef_source_mapping', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->foreign('channel_id')->references('id')->on('channels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Expenses', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Expenses', function(Blueprint $table) {
			$table->foreign('source_id')->references('id')->on('sources')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lef_sources', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('analytics_views', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('lef_source_mapping', function(Blueprint $table) {
			$table->dropForeign('lef_source_mapping_client_id_foreign');
		});
		Schema::table('lef_source_mapping', function(Blueprint $table) {
			$table->dropForeign('lef_source_mapping_source_id_foreign');
		});
		Schema::table('sources', function(Blueprint $table) {
			$table->dropForeign('sources_client_id_foreign');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->dropForeign('source_channel_mapping_client_id_foreign');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->dropForeign('source_channel_mapping_channel_id_foreign');
		});
		Schema::table('source_channel_mapping', function(Blueprint $table) {
			$table->dropForeign('source_channel_mapping_source_id_foreign');
		});
		Schema::table('Expenses', function(Blueprint $table) {
			$table->dropForeign('Expenses_client_id_foreign');
		});
		Schema::table('Expenses', function(Blueprint $table) {
			$table->dropForeign('Expenses_source_id_foreign');
		});
		Schema::table('lef_sources', function(Blueprint $table) {
			$table->dropForeign('lef_sources_client_id_foreign');
		});
		Schema::table('analytics_views', function(Blueprint $table) {
			$table->dropForeign('analytics_views_client_id_foreign');
		});
	}
}