<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('gender', 3);
			$table->string('firstname', 50);
			$table->string('lastname', 50);
			$table->string('function', 50);
			$table->string('email', 255);
			$table->string('phone', 10);
			$table->integer('partners_id')->unsigned();
			$table->string('password', 255);
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}