<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Album extends Model 
{

    protected $table = 'albums';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function artist()
    {
        return $this->belongsTo('Artist', 'artist_mdbid', 'mdbid');
    }

    public function tracks()
    {
        return $this->hasMany('Track', 'album_mdbid', 'mdbid');
    }

}