<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->string('user_mdbid', 16)->unique();
			$table->string('mobile', 255)->unique();
			$table->string('photo', 255)->nullable();
			$table->text('bio')->nullable();
			$table->string('location', 255)->nullable();
			$table->string('Facebook_username', 255)->nullable();
			$table->string('twitter_username', 255)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}