<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTracksTable extends Migration {

	public function up()
	{
		Schema::create('tracks', function(Blueprint $table) {
			$table->string('mdbid', 16);
			$table->integer('track_no');
			$table->string('title', 255);
			$table->string('sort_title', 255);
			$table->string('safe_title', 255);
			$table->integer('duration');
			$table->text('lyrics');
			$table->string('album_mdbid', 16);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tracks');
	}
}