<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->string('mdbid', 16);
			$table->string('name', 255);
			$table->date('dob');
			$table->string('email', 255)->unique();
			$table->string('username', 255)->unique();
			$table->string('password', 255);
			$table->string('key', 11);
			$table->tinyInteger('confirmed');
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}