<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Album extends Eloquent {

	protected $table = 'albums';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function artist()
	{
		return $this->belongsTo('Artist', 'artist_mdbid', 'mdbid');
	}

	public function tracks()
	{
		return $this->hasMany('Track', 'album_mdbid', 'mdbid');
	}

}