<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Track extends Eloquent {

	protected $table = 'tracks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function album()
	{
		return $this->belongsTo('Album', 'album_mdbid', 'mdbid');
	}

	public function tags()
	{
		return $this->belongsToMany('Tag', 'tag_track_user', 'track_mdbid', 'tag_mdbid')->withPivot('user_mdbid');;
	}

	public function users()
	{
		return $this->belongsToMany('User', 'tag_track_user', 'track_mdbid', 'user_mdbid')->withPivot('tag_mdbid');;
	}

}