<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('company_id')->nullable();
			$table->integer('package_id')->nullable();
			$table->datetime('start_at')->nullable();
			$table->datetime('expire_at')->nullable();
			$table->datetime('grace_at')->nullable();
			$table->integer('grace_number')->nullable();
			$table->enum('status', array('active', 'cancelled'))->nullable();
			$table->integer('payment_method_id')->nullable();
			$table->integer('months_number')->nullable();
			$table->integer('active_members')->nullable();
			$table->integer('max_members')->nullable();
			$table->datetime('cancel_date')->nullable();
			$table->boolean('is_trail')->default(0);
			$table->datetime('trail_end_at')->nullable();
			$table->string('package_title_en')->nullable();
			$table->string('package_title_ar')->nullable();
			$table->text('package_description_en')->nullable();
			$table->text('package_description_ar')->nullable();
			$table->double('package_price')->nullable();
			$table->double('subscription_price')->nullable();
			$table->double('support_price')->nullable();
			$table->double('total')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}