<?php

namespace App/Models/;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Ad extends Eloquent {

	protected $table = 'ads';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function city()
	{
		return $this->belongsTo('City');
	}

	public function package()
	{
		return $this->hasOne('Package');
	}

	public function category()
	{
		return $this->belongsTo('Category');
	}

	public function screen()
	{
		return $this->belongsTo('Screen');
	}

	public function marketer()
	{
		return $this->belongsTo('Marketer');
	}

}