<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('gallery_image_tag', function(Blueprint $table) {
			$table->foreign('gallery_image_id')->references('id')->on('gallery_images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('gallery_image_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('gallery_image_tag', function(Blueprint $table) {
			$table->dropForeign('gallery_image_tag_gallery_image_id_foreign');
		});
		Schema::table('gallery_image_tag', function(Blueprint $table) {
			$table->dropForeign('gallery_image_tag_tag_id_foreign');
		});
	}
}