<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('apartments', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('concentrators', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transmitters', function(Blueprint $table) {
			$table->foreign('site_id')->references('id')->on('sites')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('transmitters', function(Blueprint $table) {
			$table->foreign('apartment_id')->references('id')->on('apartments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('readings', function(Blueprint $table) {
			$table->foreign('transmitter_id')->references('id')->on('transmitters')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('occupancy', function(Blueprint $table) {
			$table->foreign('apartment_id')->references('id')->on('apartments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('occupancy', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenants')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('report', function(Blueprint $table) {
			$table->foreign('reading_start_id')->references('id')->on('readings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('report', function(Blueprint $table) {
			$table->foreign('reading_end_id')->references('id')->on('readings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('concentrator_status', function(Blueprint $table) {
			$table->foreign('concentrator_id')->references('id')->on('concentrators')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('apartments', function(Blueprint $table) {
			$table->dropForeign('apartments_site_id_foreign');
		});
		Schema::table('concentrators', function(Blueprint $table) {
			$table->dropForeign('concentrators_site_id_foreign');
		});
		Schema::table('transmitters', function(Blueprint $table) {
			$table->dropForeign('transmitters_site_id_foreign');
		});
		Schema::table('transmitters', function(Blueprint $table) {
			$table->dropForeign('transmitters_apartment_id_foreign');
		});
		Schema::table('readings', function(Blueprint $table) {
			$table->dropForeign('readings_transmitter_id_foreign');
		});
		Schema::table('occupancy', function(Blueprint $table) {
			$table->dropForeign('occupancy_apartment_id_foreign');
		});
		Schema::table('occupancy', function(Blueprint $table) {
			$table->dropForeign('occupancy_tenant_id_foreign');
		});
		Schema::table('report', function(Blueprint $table) {
			$table->dropForeign('report_reading_start_id_foreign');
		});
		Schema::table('report', function(Blueprint $table) {
			$table->dropForeign('report_reading_end_id_foreign');
		});
		Schema::table('concentrator_status', function(Blueprint $table) {
			$table->dropForeign('concentrator_status_concentrator_id_foreign');
		});
	}
}