<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Episode extends Model 
{

    protected $table = 'episodes';
    public $timestamps = true;

    public function podcast()
    {
        return $this->belongsTo('Podcast');
    }

    public function tags()
    {
        return $this->belongsToMany('Tag');
    }

    public function quiz()
    {
        return $this->morphOne('Quiz', 'quizzable');
    }

}