<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function quiz()
    {
        return $this->belongsTo('Quiz');
    }

    public function options()
    {
        return $this->hasMany('QuizOption');
    }

    public function correct()
    {
        return $this->belongsTo('QuizOption');
    }

}